"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    platform_name: str,
    platform_version: str,
    platform_definition_bundle: Dict,
    environment_name: str = None,
    option_settings: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new version of your custom platform.

    Args:
        platform_name(str): The name of your custom platform.
        platform_version(str): The number, such as 1.0.2, for the new platform version.
        platform_definition_bundle(Dict): The location of the platform definition archive in Amazon S3.
        environment_name(str, optional): The name of the builder environment. Defaults to None.
        option_settings(List, optional): The configuration option settings to apply to the builder environment. Defaults to None.
        tags(List, optional): Specifies the tags applied to the new platform version. Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the platform version don't inherit the tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.platform.version.create(
                ctx, platform_name=value, platform_version=value, platform_definition_bundle=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.platform.version.create platform_name=value, platform_version=value, platform_definition_bundle=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="create_platform_version",
        op_kwargs={
            "PlatformName": platform_name,
            "PlatformVersion": platform_version,
            "PlatformDefinitionBundle": platform_definition_bundle,
            "EnvironmentName": environment_name,
            "OptionSettings": option_settings,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, platform_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified version of a custom platform.

    Args:
        platform_arn(str, optional): The ARN of the version of the custom platform. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.platform.version.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.platform.version.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="delete_platform_version",
        op_kwargs={"PlatformArn": platform_arn},
    )


async def describe(hub, ctx, platform_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of platform versions. For definitions of platform version and other platform-related terms, see AWS Elastic Beanstalk Platforms Glossary.

    Args:
        platform_arn(str, optional): The ARN of the platform version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.platform.version.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.platform.version.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_platform_version",
        op_kwargs={"PlatformArn": platform_arn},
    )


async def list_all(
    hub, ctx, filters: List = None, max_records: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform version. For definitions of platform version and other platform-related terms, see AWS Elastic Beanstalk Platforms Glossary.

    Args:
        filters(List, optional): Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical conjunction (AND) of the separate PlatformFilter terms. Defaults to None.
        max_records(int, optional): The maximum number of platform version values returned in one call. Defaults to None.
        next_token(str, optional): For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request. If no NextToken is specified, the first page is retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.platform.version.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.platform.version.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="list_platform_versions",
        op_kwargs={
            "Filters": filters,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )
