"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    environment_name: str = None,
    environment_id: str = None,
    attribute_names: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires enhanced health reporting.

    Args:
        environment_name(str, optional): Specify the AWS Elastic Beanstalk environment by name. Defaults to None.
        environment_id(str, optional): Specify the AWS Elastic Beanstalk environment by ID. Defaults to None.
        attribute_names(List, optional): Specifies the response elements you wish to receive. To retrieve all attributes, set to All. If no attribute names are specified, returns a list of instances. Defaults to None.
        next_token(str, optional): Specify the pagination token returned by a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.instance_health.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.instance_health.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_instances_health",
        op_kwargs={
            "EnvironmentName": environment_name,
            "EnvironmentId": environment_id,
            "AttributeNames": attribute_names,
            "NextToken": next_token,
        },
    )
