"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    application_name: str = None,
    version_label: str = None,
    template_name: str = None,
    environment_id: str = None,
    environment_name: str = None,
    platform_arn: str = None,
    request_id: str = None,
    severity: str = None,
    start_time: str = None,
    end_time: str = None,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns list of event descriptions matching criteria up to the last 6 weeks.  This action returns the most recent 1,000 events from the specified NextToken.

    Args:
        application_name(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with this application. Defaults to None.
        version_label(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application version. Defaults to None.
        template_name(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this environment configuration. Defaults to None.
        environment_id(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment. Defaults to None.
        environment_name(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this environment. Defaults to None.
        platform_arn(str, optional): The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this custom platform version. Defaults to None.
        request_id(str, optional): If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this request ID. Defaults to None.
        severity(str, optional): If specified, limits the events returned from this call to include only those with the specified severity or higher. Defaults to None.
        start_time(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this time. Defaults to None.
        end_time(str, optional):  If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not including, the EndTime. . Defaults to None.
        max_records(int, optional): Specifies the maximum number of events that can be returned, beginning with the most recent event. Defaults to None.
        next_token(str, optional): Pagination token. If specified, the events return the next batch of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.event.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.event.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_events",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabel": version_label,
            "TemplateName": template_name,
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "PlatformArn": platform_arn,
            "RequestId": request_id,
            "Severity": severity,
            "StartTime": start_time,
            "EndTime": end_time,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )
