"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def abort(
    hub, ctx, environment_id: str = None, environment_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Cancels in-progress environment configuration update or application version deployment.

    Args:
        environment_id(str, optional): This specifies the ID of the environment with the in-progress update that you want to cancel. Defaults to None.
        environment_name(str, optional): This specifies the name of the environment with the in-progress update that you want to cancel. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.update.abort(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.update.abort
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="abort_environment_update",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
        },
    )
