"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def associate(hub, ctx, environment_name: str, operations_role: str) -> None:
    r"""
    **Autogenerated function**

    Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see Operations roles in the AWS Elastic Beanstalk Developer Guide.

    Args:
        environment_name(str): The name of the environment to which to set the operations role.
        operations_role(str): The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.operation_role.associate(
                ctx, environment_name=value, operations_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.operation_role.associate environment_name=value, operations_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="associate_environment_operations_role",
        op_kwargs={
            "EnvironmentName": environment_name,
            "OperationsRole": operations_role,
        },
    )


async def disassociate(hub, ctx, environment_name: str) -> None:
    r"""
    **Autogenerated function**

    Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see Operations roles in the AWS Elastic Beanstalk Developer Guide.

    Args:
        environment_name(str): The name of the environment from which to disassociate the operations role.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.operation_role.disassociate(
                ctx, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.operation_role.disassociate environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="disassociate_environment_operations_role",
        op_kwargs={"EnvironmentName": environment_name},
    )
