"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def apply(
    hub, ctx, action_id: str, environment_name: str = None, environment_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a scheduled managed action immediately. A managed action can be applied only if its status is Scheduled. Get the status and action ID of a managed action with DescribeEnvironmentManagedActions.

    Args:
        environment_name(str, optional): The name of the target environment. Defaults to None.
        environment_id(str, optional): The environment ID of the target environment. Defaults to None.
        action_id(str): The action ID of the scheduled managed action to execute.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.managed_action.init.apply(
                ctx, action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.managed_action.init.apply action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="apply_environment_managed_action",
        op_kwargs={
            "EnvironmentName": environment_name,
            "EnvironmentId": environment_id,
            "ActionId": action_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    environment_name: str = None,
    environment_id: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists an environment's upcoming and in-progress managed actions.

    Args:
        environment_name(str, optional): The name of the target environment. Defaults to None.
        environment_id(str, optional): The environment ID of the target environment. Defaults to None.
        status(str, optional): To show only actions with a particular status, specify a status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.managed_action.init.describe_all(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.managed_action.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_environment_managed_actions",
        op_kwargs={
            "EnvironmentName": environment_name,
            "EnvironmentId": environment_id,
            "Status": status,
        },
    )
