"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    environment_id: str = None,
    environment_name: str = None,
    next_token: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists an environment's completed and failed managed actions.

    Args:
        environment_id(str, optional): The environment ID of the target environment. Defaults to None.
        environment_name(str, optional): The name of the target environment. Defaults to None.
        next_token(str, optional): The pagination token returned by a previous request. Defaults to None.
        max_items(int, optional): The maximum number of items to return for a single request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.managed_action.history.describe(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.managed_action.history.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_environment_managed_action_history",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "NextToken": next_token,
            "MaxItems": max_items,
        },
    )
