"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def compose(
    hub,
    ctx,
    application_name: str = None,
    group_name: str = None,
    version_labels: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named env.yaml. See Compose Environments for details.

    Args:
        application_name(str, optional): The name of the application to which the specified source bundles belong. Defaults to None.
        group_name(str, optional): The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See Environment Manifest (env.yaml) for details. Defaults to None.
        version_labels(List, optional): A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.compose(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.compose
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="compose_environments",
        op_kwargs={
            "ApplicationName": application_name,
            "GroupName": group_name,
            "VersionLabels": version_labels,
        },
    )


async def create(
    hub,
    ctx,
    application_name: str,
    environment_name: str = None,
    group_name: str = None,
    description: str = None,
    cname_prefix: str = None,
    tier: Dict = None,
    tags: List = None,
    version_label: str = None,
    template_name: str = None,
    solution_stack_name: str = None,
    platform_arn: str = None,
    option_settings: List = None,
    options_to_remove: List = None,
    operations_role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.

    Args:
        application_name(str): The name of the application that is associated with this environment.
        environment_name(str, optional): A unique name for the environment. Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an InvalidParameterValue error.  If you don't specify the CNAMEPrefix parameter, the environment name becomes part of the CNAME, and therefore part of the visible URL for your application. Defaults to None.
        group_name(str, optional): The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name parameter. See Environment Manifest (env.yaml) for details. Defaults to None.
        description(str, optional): Your description for this environment. Defaults to None.
        cname_prefix(str, optional): If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string to the environment name. Defaults to None.
        tier(Dict, optional): Specifies the tier to use in creating this environment. The environment tier that you choose determines whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web application that handles background-processing tasks. Defaults to None.
        tags(List, optional): Specifies the tags applied to resources in the environment. Defaults to None.
        version_label(str, optional): The name of the application version to deploy. Default: If not specified, Elastic Beanstalk attempts to deploy the sample application. Defaults to None.
        template_name(str, optional): The name of the Elastic Beanstalk configuration template to use with the environment.  If you specify TemplateName, then don't specify SolutionStackName. . Defaults to None.
        solution_stack_name(str, optional): The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified, Elastic Beanstalk sets the configuration values to the default values associated with the specified solution stack. For a list of current solution stacks, see Elastic Beanstalk Supported Platforms in the AWS Elastic Beanstalk Platforms guide.  If you specify SolutionStackName, don't specify PlatformArn or TemplateName. . Defaults to None.
        platform_arn(str, optional): The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see Custom Platforms in the AWS Elastic Beanstalk Developer Guide.  If you specify PlatformArn, don't specify SolutionStackName. . Defaults to None.
        option_settings(List, optional): If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the configuration set for the new environment. These override the values obtained from the solution stack or the configuration template. Defaults to None.
        options_to_remove(List, optional): A list of custom user-defined configuration options to remove from the configuration set for this new environment. Defaults to None.
        operations_role(str, optional): The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and during subsequent calls acting on this environment. To specify an operations role, you must have the iam:PassRole permission for the role. For more information, see Operations roles in the AWS Elastic Beanstalk Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.create(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.create application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="create_environment",
        op_kwargs={
            "ApplicationName": application_name,
            "EnvironmentName": environment_name,
            "GroupName": group_name,
            "Description": description,
            "CNAMEPrefix": cname_prefix,
            "Tier": tier,
            "Tags": tags,
            "VersionLabel": version_label,
            "TemplateName": template_name,
            "SolutionStackName": solution_stack_name,
            "PlatformArn": platform_arn,
            "OptionSettings": option_settings,
            "OptionsToRemove": options_to_remove,
            "OperationsRole": operations_role,
        },
    )


async def describe_all(
    hub,
    ctx,
    application_name: str = None,
    version_label: str = None,
    environment_ids: List = None,
    environment_names: List = None,
    include_deleted: bool = None,
    included_deleted_back_to: str = None,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptions for existing environments.

    Args:
        application_name(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application. Defaults to None.
        version_label(str, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version. Defaults to None.
        environment_ids(List, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs. Defaults to None.
        environment_names(List, optional): If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names. Defaults to None.
        include_deleted(bool, optional): Indicates whether to include deleted environments:  true: Environments that have been deleted after IncludedDeletedBackTo are displayed.  false: Do not include deleted environments. Defaults to None.
        included_deleted_back_to(str, optional):  If specified when IncludeDeleted is set to true, then environments deleted after this date are displayed. . Defaults to None.
        max_records(int, optional): For a paginated request. Specify a maximum number of environments to include in each response. If no MaxRecords is specified, all available environments are retrieved in a single response. Defaults to None.
        next_token(str, optional): For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request. If no NextToken is specified, the first page is retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_environments",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabel": version_label,
            "EnvironmentIds": environment_ids,
            "EnvironmentNames": environment_names,
            "IncludeDeleted": include_deleted,
            "IncludedDeletedBackTo": included_deleted_back_to,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )


async def rebuild(
    hub, ctx, environment_id: str = None, environment_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.

    Args:
        environment_id(str, optional): The ID of the environment to rebuild.  Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment to rebuild.  Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.rebuild(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.rebuild
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="rebuild_environment",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
        },
    )


async def terminate(
    hub,
    ctx,
    environment_id: str = None,
    environment_name: str = None,
    terminate_resources: bool = None,
    force_terminate: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Terminates the specified environment.

    Args:
        environment_id(str, optional): The ID of the environment to terminate.  Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment to terminate.  Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        terminate_resources(bool, optional): Indicates whether the associated AWS resources should shut down when the environment is terminated:    true: The specified environment as well as the associated AWS resources, such as Auto Scaling group and LoadBalancer, are terminated.    false: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS resources continue to operate.    For more information, see the  AWS Elastic Beanstalk User Guide.    Default: true   Valid Values: true | false . Defaults to None.
        force_terminate(bool, optional): Terminates the target environment even if another environment in the same group is dependent on it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.terminate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.terminate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="terminate_environment",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "TerminateResources": terminate_resources,
            "ForceTerminate": force_terminate,
        },
    )


async def update(
    hub,
    ctx,
    application_name: str = None,
    environment_id: str = None,
    environment_name: str = None,
    group_name: str = None,
    description: str = None,
    tier: Dict = None,
    version_label: str = None,
    template_name: str = None,
    solution_stack_name: str = None,
    platform_arn: str = None,
    option_settings: List = None,
    options_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.  Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an InvalidParameterCombination error.   When updating the configuration settings to a new template or individual settings, a draft configuration is created and DescribeConfigurationSettings for this environment returns two setting descriptions with different DeploymentStatus values.

    Args:
        application_name(str, optional): The name of the application with which the environment is associated. Defaults to None.
        environment_id(str, optional): The ID of the environment to update. If no environment with this ID exists, AWS Elastic Beanstalk returns an InvalidParameterValue error. Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an InvalidParameterValue error.  Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        group_name(str, optional): The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See Environment Manifest (env.yaml) for details. Defaults to None.
        description(str, optional): If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment. Defaults to None.
        tier(Dict, optional): This specifies the tier to use to update the environment. Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns InvalidParameterValue error. . Defaults to None.
        version_label(str, optional): If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an InvalidParameterValue error. . Defaults to None.
        template_name(str, optional): If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an InvalidParameterValue error. . Defaults to None.
        solution_stack_name(str, optional): This specifies the platform version that the environment will run after the environment is updated. Defaults to None.
        platform_arn(str, optional): The ARN of the platform, if used. Defaults to None.
        option_settings(List, optional): If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value. Defaults to None.
        options_to_remove(List, optional): A list of custom user-defined configuration options to remove from the configuration set for this environment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="update_environment",
        op_kwargs={
            "ApplicationName": application_name,
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "GroupName": group_name,
            "Description": description,
            "Tier": tier,
            "VersionLabel": version_label,
            "TemplateName": template_name,
            "SolutionStackName": solution_stack_name,
            "PlatformArn": platform_arn,
            "OptionSettings": option_settings,
            "OptionsToRemove": options_to_remove,
        },
    )
