"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def request(
    hub, ctx, info_type: str, environment_id: str = None, environment_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Initiates a request to compile the specified type of information of the deployed environment.  Setting the InfoType to tail compiles the last lines from the application server log files of every Amazon EC2 instance in your environment.   Setting the InfoType to bundle compresses the application server log files for every Amazon EC2 instance into a .zip file. Legacy and .NET containers do not support bundle logs.   Use RetrieveEnvironmentInfo to obtain the set of logs.  Related Topics    RetrieveEnvironmentInfo

    Args:
        environment_id(str, optional): The ID of the environment of the requested data. If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue error.  Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment of the requested data. If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue error.  Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        info_type(str): The type of information to request.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.info.request(ctx, info_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.info.request info_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="request_environment_info",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "InfoType": info_type,
        },
    )


async def retrieve(
    hub, ctx, info_type: str, environment_id: str = None, environment_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the compiled information from a RequestEnvironmentInfo request. Related Topics    RequestEnvironmentInfo

    Args:
        environment_id(str, optional): The ID of the data's environment. If no such environment is found, returns an InvalidParameterValue error. Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. Defaults to None.
        environment_name(str, optional): The name of the data's environment.  If no such environment is found, returns an InvalidParameterValue error.   Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        info_type(str): The type of information to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.info.retrieve(ctx, info_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.info.retrieve info_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="retrieve_environment_info",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
            "InfoType": info_type,
        },
    )
