"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    environment_name: str = None,
    environment_id: str = None,
    attribute_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the overall health of the specified environment. The DescribeEnvironmentHealth operation is only available with AWS Elastic Beanstalk Enhanced Health.

    Args:
        environment_name(str, optional): Specify the environment by name. You must specify either this or an EnvironmentName, or both. Defaults to None.
        environment_id(str, optional): Specify the environment by ID. You must specify either this or an EnvironmentName, or both. Defaults to None.
        attribute_names(List, optional): Specify the response elements to return. To retrieve all attributes, set to All. If no attribute names are specified, returns the name of the environment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.health.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.health.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_environment_health",
        op_kwargs={
            "EnvironmentName": environment_name,
            "EnvironmentId": environment_id,
            "AttributeNames": attribute_names,
        },
    )
