"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, application_name: str, environment_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the draft configuration associated with the running environment. Updating a running environment with any configuration changes creates a draft configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update fails. The DeploymentStatus for the draft configuration indicates whether the deployment is in process or has failed. The draft configuration remains in existence until it is deleted with this action.

    Args:
        application_name(str): The name of the application the environment is associated with.
        environment_name(str): The name of the environment to delete the draft configuration from.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.configuration.delete(
                ctx, application_name=value, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.configuration.delete application_name=value, environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="delete_environment_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "EnvironmentName": environment_name,
        },
    )
