"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def swap(
    hub,
    ctx,
    source_environment_id: str = None,
    source_environment_name: str = None,
    destination_environment_id: str = None,
    destination_environment_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Swaps the CNAMEs of two environments.

    Args:
        source_environment_id(str, optional): The ID of the source environment.  Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName. You may also specify both. If you specify the SourceEnvironmentId, you must specify the DestinationEnvironmentId. . Defaults to None.
        source_environment_name(str, optional): The name of the source environment.  Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName. You may also specify both. If you specify the SourceEnvironmentName, you must specify the DestinationEnvironmentName. . Defaults to None.
        destination_environment_id(str, optional): The ID of the destination environment.  Condition: You must specify at least the DestinationEnvironmentID or the DestinationEnvironmentName. You may also specify both. You must specify the SourceEnvironmentId with the DestinationEnvironmentId. . Defaults to None.
        destination_environment_name(str, optional): The name of the destination environment.  Condition: You must specify at least the DestinationEnvironmentID or the DestinationEnvironmentName. You may also specify both. You must specify the SourceEnvironmentName with the DestinationEnvironmentName. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.environment.cname.swap(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.environment.cname.swap
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="swap_environment_cnames",
        op_kwargs={
            "SourceEnvironmentId": source_environment_id,
            "SourceEnvironmentName": source_environment_name,
            "DestinationEnvironmentId": destination_environment_id,
            "DestinationEnvironmentName": destination_environment_name,
        },
    )
