"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def check(hub, ctx, cname_prefix: str) -> Dict:
    r"""
    **Autogenerated function**

    Checks if the specified CNAME is available.

    Args:
        cname_prefix(str): The prefix used when this CNAME is reserved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.dns_availability.check(ctx, cname_prefix=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.dns_availability.check cname_prefix=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="check_dns_availability",
        op_kwargs={"CNAMEPrefix": cname_prefix},
    )
