"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_name: str,
    template_name: str,
    solution_stack_name: str = None,
    platform_arn: str = None,
    source_configuration: Dict = None,
    environment_id: str = None,
    description: str = None,
    option_settings: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings. Templates aren't associated with any environment. The EnvironmentName response element is always null. Related Topics    DescribeConfigurationOptions     DescribeConfigurationSettings     ListAvailableSolutionStacks

    Args:
        application_name(str): The name of the Elastic Beanstalk application to associate with this configuration template.
        template_name(str): The name of the configuration template. Constraint: This name must be unique per application.
        solution_stack_name(str, optional): The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, 64bit Amazon Linux 2013.09 running Tomcat 7 Java 7. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see Supported Platforms in the AWS Elastic Beanstalk Developer Guide. You must specify SolutionStackName if you don't specify PlatformArn, EnvironmentId, or SourceConfiguration. Use the  ListAvailableSolutionStacks  API to obtain a list of available solution stacks. Defaults to None.
        platform_arn(str, optional): The Amazon Resource Name (ARN) of the custom platform. For more information, see  Custom Platforms in the AWS Elastic Beanstalk Developer Guide.  If you specify PlatformArn, then don't specify SolutionStackName. . Defaults to None.
        source_configuration(Dict, optional): An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration. Values specified in OptionSettings override any values obtained from the SourceConfiguration. You must specify SourceConfiguration if you don't specify PlatformArn, EnvironmentId, or SolutionStackName. Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name. Defaults to None.
        environment_id(str, optional): The ID of an environment whose settings you want to use to create the configuration template. You must specify EnvironmentId if you don't specify PlatformArn, SolutionStackName, or SourceConfiguration. Defaults to None.
        description(str, optional): An optional description for this configuration. Defaults to None.
        option_settings(List, optional): Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see Option Values in the AWS Elastic Beanstalk Developer Guide. Defaults to None.
        tags(List, optional): Specifies the tags applied to the configuration template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.template.create(
                ctx, application_name=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.template.create application_name=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="create_configuration_template",
        op_kwargs={
            "ApplicationName": application_name,
            "TemplateName": template_name,
            "SolutionStackName": solution_stack_name,
            "PlatformArn": platform_arn,
            "SourceConfiguration": source_configuration,
            "EnvironmentId": environment_id,
            "Description": description,
            "OptionSettings": option_settings,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, application_name: str, template_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified configuration template.  When you launch an environment using a configuration template, the environment gets a copy of the template. You can delete or modify the environment's copy of the template without affecting the running environment.

    Args:
        application_name(str): The name of the application to delete the configuration template from.
        template_name(str): The name of the configuration template to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.template.delete(
                ctx, application_name=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.template.delete application_name=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="delete_configuration_template",
        op_kwargs={"ApplicationName": application_name, "TemplateName": template_name},
    )


async def update(
    hub,
    ctx,
    application_name: str,
    template_name: str,
    description: str = None,
    option_settings: List = None,
    options_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified configuration template to have the specified properties or configuration option values.  If a property (for example, ApplicationName) is not provided, its value remains unchanged. To clear such properties, specify an empty string.  Related Topics    DescribeConfigurationOptions

    Args:
        application_name(str): The name of the application associated with the configuration template to update.  If no application is found with this name, UpdateConfigurationTemplate returns an InvalidParameterValue error. .
        template_name(str): The name of the configuration template to update.  If no configuration template is found with this name, UpdateConfigurationTemplate returns an InvalidParameterValue error. .
        description(str, optional): A new description for the configuration. Defaults to None.
        option_settings(List, optional): A list of configuration option settings to update with the new specified option value. Defaults to None.
        options_to_remove(List, optional): A list of configuration options to remove from the configuration set.  Constraint: You can remove only UserDefined configuration options. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.template.update(
                ctx, application_name=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.template.update application_name=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="update_configuration_template",
        op_kwargs={
            "ApplicationName": application_name,
            "TemplateName": template_name,
            "Description": description,
            "OptionSettings": option_settings,
            "OptionsToRemove": options_to_remove,
        },
    )
