"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    application_name: str,
    template_name: str = None,
    environment_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment. When describing the settings for the configuration set associated with a running environment, it is possible to receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft configuration of an environment that is either in the process of deployment or that failed to deploy. Related Topics    DeleteEnvironmentConfiguration

    Args:
        application_name(str): The application for the environment or configuration template.
        template_name(str, optional): The name of the configuration template to describe.  Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment to describe.  Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination error. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.setting.describe_all(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.setting.describe_all application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_configuration_settings",
        op_kwargs={
            "ApplicationName": application_name,
            "TemplateName": template_name,
            "EnvironmentName": environment_name,
        },
    )


async def validate(
    hub,
    ctx,
    application_name: str,
    option_settings: List,
    template_name: str = None,
    environment_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid. This action returns a list of messages indicating any errors or warnings associated with the selection of option values.

    Args:
        application_name(str): The name of the application that the configuration template or environment belongs to.
        template_name(str, optional): The name of the configuration template to validate the settings against. Condition: You cannot specify both this and an environment name. Defaults to None.
        environment_name(str, optional): The name of the environment to validate the settings against. Condition: You cannot specify both this and a configuration template name. Defaults to None.
        option_settings(List): A list of the options and desired values to evaluate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.setting.validate(
                ctx, application_name=value, option_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.setting.validate application_name=value, option_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="validate_configuration_settings",
        op_kwargs={
            "ApplicationName": application_name,
            "TemplateName": template_name,
            "EnvironmentName": environment_name,
            "OptionSettings": option_settings,
        },
    )
