"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    application_name: str = None,
    template_name: str = None,
    environment_name: str = None,
    solution_stack_name: str = None,
    platform_arn: str = None,
    options: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.

    Args:
        application_name(str, optional): The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment. Defaults to None.
        template_name(str, optional): The name of the configuration template whose configuration options you want to describe. Defaults to None.
        environment_name(str, optional): The name of the environment whose configuration options you want to describe. Defaults to None.
        solution_stack_name(str, optional): The name of the solution stack whose configuration options you want to describe. Defaults to None.
        platform_arn(str, optional): The ARN of the custom platform. Defaults to None.
        options(List, optional): If specified, restricts the descriptions to only the specified options. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.configuration.option.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.configuration.option.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_configuration_options",
        op_kwargs={
            "ApplicationName": application_name,
            "TemplateName": template_name,
            "EnvironmentName": environment_name,
            "SolutionStackName": solution_stack_name,
            "PlatformArn": platform_arn,
            "Options": options,
        },
    )
