"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_name: str,
    version_label: str,
    description: str = None,
    source_build_information: Dict = None,
    source_bundle: Dict = None,
    build_configuration: Dict = None,
    auto_create_application: bool = None,
    process: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows: Specify a commit in an AWS CodeCommit repository with SourceBuildInformation. Specify a build in an AWS CodeBuild with SourceBuildInformation and BuildConfiguration. Specify a source bundle in S3 with SourceBundle  Omit both SourceBuildInformation and SourceBundle to use the default sample application.  After you create an application version with a specified Amazon S3 bucket and key location, you can't change that Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an environment from the application version.

    Args:
        application_name(str):  The name of the application. If no application is found with this name, and AutoCreateApplication is false, returns an InvalidParameterValue error. .
        version_label(str): A label identifying this version. Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an InvalidParameterValue error. .
        description(str, optional): A description of this application version. Defaults to None.
        source_build_information(Dict, optional): Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version. Defaults to None.
        source_bundle(Dict, optional): The Amazon S3 bucket and key that identify the location of the source bundle for this version.  The Amazon S3 bucket must be in the same region as the environment.  Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with SourceBuildInformation), but not both. If neither SourceBundle nor SourceBuildInformation are provided, Elastic Beanstalk uses a sample application. Defaults to None.
        build_configuration(Dict, optional): Settings for an AWS CodeBuild build. Defaults to None.
        auto_create_application(bool, optional): Set to true to create an application with the specified name if it doesn't already exist. Defaults to None.
        process(bool, optional): Pre-processes and validates the environment manifest (env.yaml) and configuration files (*.config files in the .ebextensions folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment. You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.  The Process option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration. . Defaults to None.
        tags(List, optional): Specifies the tags applied to the application version. Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.application.version.create(
                ctx, application_name=value, version_label=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.application.version.create application_name=value, version_label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="create_application_version",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabel": version_label,
            "Description": description,
            "SourceBuildInformation": source_build_information,
            "SourceBundle": source_bundle,
            "BuildConfiguration": build_configuration,
            "AutoCreateApplication": auto_create_application,
            "Process": process,
            "Tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    version_label: str,
    delete_source_bundle: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified version from the specified application.  You cannot delete an application version that is associated with a running environment.

    Args:
        application_name(str): The name of the application to which the version belongs.
        version_label(str): The label of the version to delete.
        delete_source_bundle(bool, optional): Set to true to delete the source bundle from your storage bucket. Otherwise, the application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.application.version.delete(
                ctx, application_name=value, version_label=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.application.version.delete application_name=value, version_label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="delete_application_version",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabel": version_label,
            "DeleteSourceBundle": delete_source_bundle,
        },
    )


async def describe_all(
    hub,
    ctx,
    application_name: str = None,
    version_labels: List = None,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a list of application versions.

    Args:
        application_name(str, optional): Specify an application name to show only application versions for that application. Defaults to None.
        version_labels(List, optional): Specify a version label to show a specific application version. Defaults to None.
        max_records(int, optional): For a paginated request. Specify a maximum number of application versions to include in each response. If no MaxRecords is specified, all available application versions are retrieved in a single response. Defaults to None.
        next_token(str, optional): For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request. If no NextToken is specified, the first page is retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.application.version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.application.version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="describe_application_versions",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabels": version_labels,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, application_name: str, version_label: str, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified application version to have the specified properties.  If a property (for example, description) is not provided, the value remains unchanged. To clear properties, specify an empty string.

    Args:
        application_name(str): The name of the application associated with this version.  If no application is found with this name, UpdateApplication returns an InvalidParameterValue error.
        version_label(str): The name of the version to update. If no application version is found with this label, UpdateApplication returns an InvalidParameterValue error. .
        description(str, optional): A new description for this version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.application.version.update(
                ctx, application_name=value, version_label=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.application.version.update application_name=value, version_label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="update_application_version",
        op_kwargs={
            "ApplicationName": application_name,
            "VersionLabel": version_label,
            "Description": description,
        },
    )
