"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, application_name: str, resource_lifecycle_config: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies lifecycle settings for an application.

    Args:
        application_name(str): The name of the application.
        resource_lifecycle_config(Dict): The lifecycle configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.application.resource_lifecycle.update(
                ctx, application_name=value, resource_lifecycle_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.application.resource_lifecycle.update application_name=value, resource_lifecycle_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="update_application_resource_lifecycle",
        op_kwargs={
            "ApplicationName": application_name,
            "ResourceLifecycleConfig": resource_lifecycle_config,
        },
    )
