"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def restart(
    hub, ctx, environment_id: str = None, environment_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Causes the environment to restart the application container server running on each Amazon EC2 instance.

    Args:
        environment_id(str, optional): The ID of the environment to restart the server for.  Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
        environment_name(str, optional): The name of the environment to restart the server for.  Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticbeanstalk.app.server.restart(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticbeanstalk.app.server.restart
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticbeanstalk",
        operation="restart_app_server",
        op_kwargs={
            "EnvironmentId": environment_id,
            "EnvironmentName": environment_name,
        },
    )
