"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    user_id: str,
    user_name: str,
    engine: str,
    access_string: str,
    passwords: List = None,
    no_password_required: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For Redis engine version 6.x onwards: Creates a Redis user. For more information, see Using Role Based Access Control (RBAC).

    Args:
        user_id(str): The ID of the user.
        user_name(str): The username of the user.
        engine(str): The current supported value is Redis. .
        passwords(List, optional): Passwords used for this user. You can create up to two passwords for each user. Defaults to None.
        access_string(str): Access permissions string used for this user.
        no_password_required(bool, optional): Indicates a password is not required for this user. Defaults to None.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.init.create(
                ctx, user_id=value, user_name=value, engine=value, access_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.init.create user_id=value, user_name=value, engine=value, access_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_user",
        op_kwargs={
            "UserId": user_id,
            "UserName": user_name,
            "Engine": engine,
            "Passwords": passwords,
            "AccessString": access_string,
            "NoPasswordRequired": no_password_required,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    For Redis engine version 6.x onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see Using Role Based Access Control (RBAC).

    Args:
        user_id(str): The ID of the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.init.delete(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.init.delete user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_user",
        op_kwargs={"UserId": user_id},
    )


async def describe_all(
    hub,
    ctx,
    engine: str = None,
    user_id: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of users.

    Args:
        engine(str, optional): The Redis engine. . Defaults to None.
        user_id(str, optional): The ID of the user. Defaults to None.
        filters(List, optional): Filter to determine the list of User IDs to return. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. . Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. >. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_users",
        op_kwargs={
            "Engine": engine,
            "UserId": user_id,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    user_id: str,
    access_string: str = None,
    append_access_string: str = None,
    passwords: List = None,
    no_password_required: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes user password(s) and/or access string.

    Args:
        user_id(str): The ID of the user.
        access_string(str, optional): Access permissions string used for this user. Defaults to None.
        append_access_string(str, optional): Adds additional user permissions to the access string. Defaults to None.
        passwords(List, optional): The passwords belonging to the user. You are allowed up to two. Defaults to None.
        no_password_required(bool, optional): Indicates no password is required for the user. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.init.modify(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.init.modify user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_user",
        op_kwargs={
            "UserId": user_id,
            "AccessString": access_string,
            "AppendAccessString": append_access_string,
            "Passwords": passwords,
            "NoPasswordRequired": no_password_required,
        },
    )
