"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, user_group_id: str, engine: str, user_ids: List = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    For Redis engine version 6.x onwards: Creates a Redis user group. For more information, see Using Role Based Access Control (RBAC)

    Args:
        user_group_id(str): The ID of the user group.
        engine(str): The current supported value is Redis. .
        user_ids(List, optional): The list of user IDs that belong to the user group. Defaults to None.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.group.create(
                ctx, user_group_id=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.group.create user_group_id=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_user_group",
        op_kwargs={
            "UserGroupId": user_group_id,
            "Engine": engine,
            "UserIds": user_ids,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, user_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    For Redis engine version 6.x onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see Using Role Based Access Control (RBAC).

    Args:
        user_group_id(str): The ID of the user group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.group.delete(ctx, user_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.group.delete user_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_user_group",
        op_kwargs={"UserGroupId": user_group_id},
    )


async def describe_all(
    hub, ctx, user_group_id: str = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of user groups.

    Args:
        user_group_id(str, optional): The ID of the user group. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. . Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. >. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_user_groups",
        op_kwargs={
            "UserGroupId": user_group_id,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    user_group_id: str,
    user_ids_to_add: List = None,
    user_ids_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the list of users that belong to the user group.

    Args:
        user_group_id(str): The ID of the user group.
        user_ids_to_add(List, optional): The list of user IDs to add to the user group. Defaults to None.
        user_ids_to_remove(List, optional): The list of user IDs to remove from the user group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.user.group.modify(ctx, user_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.user.group.modify user_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_user_group",
        op_kwargs={
            "UserGroupId": user_group_id,
            "UserIdsToAdd": user_ids_to_add,
            "UserIdsToRemove": user_ids_to_remove,
        },
    )
