"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    service_update_name: str = None,
    replication_group_ids: List = None,
    cache_cluster_ids: List = None,
    engine: str = None,
    service_update_status: List = None,
    service_update_time_range: Dict = None,
    update_action_status: List = None,
    show_node_level_update_status: bool = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns details of the update actions

    Args:
        service_update_name(str, optional): The unique ID of the service update. Defaults to None.
        replication_group_ids(List, optional): The replication group IDs. Defaults to None.
        cache_cluster_ids(List, optional): The cache cluster IDs. Defaults to None.
        engine(str, optional): The Elasticache engine to which the update applies. Either Redis or Memcached . Defaults to None.
        service_update_status(List, optional): The status of the service update. Defaults to None.
        service_update_time_range(Dict, optional): The range of time specified to search for service updates that are in available status. Defaults to None.
        update_action_status(List, optional): The status of the update action. Defaults to None.
        show_node_level_update_status(bool, optional): Dictates whether to include node level update status in the response . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.update_action.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.update_action.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_update_actions",
        op_kwargs={
            "ServiceUpdateName": service_update_name,
            "ReplicationGroupIds": replication_group_ids,
            "CacheClusterIds": cache_cluster_ids,
            "Engine": engine,
            "ServiceUpdateStatus": service_update_status,
            "ServiceUpdateTimeRange": service_update_time_range,
            "UpdateActionStatus": update_action_status,
            "ShowNodeLevelUpdateStatus": show_node_level_update_status,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
