"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, resource_name: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the tags identified by the TagKeys list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see Resource-level permissions.

    Args:
        resource_name(str): The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster or arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot. For more information about ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces.
        tag_keys(List): A list of TagKeys identifying the tags you want removed from the named resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.tags.from_resource.remove(
                ctx, resource_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.tags.from_resource.remove resource_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceName": resource_name, "TagKeys": tag_keys},
    )
