"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_snapshot_name: str,
    target_snapshot_name: str,
    target_bucket: str = None,
    kms_key_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Makes a copy of an existing snapshot.  This operation is valid for Redis only.   Users or groups that have permissions to use the CopySnapshot operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the CopySnapshot operation. For more information about using IAM to control the use of ElastiCache operations, see Exporting Snapshots and Authentication & Access Control.  You could receive the following error messages.  Error Messages     Error Message: The S3 bucket %s is outside of the region.  Solution: Create an Amazon S3 bucket in the same region as your snapshot. For more information, see Step 1: Create an Amazon S3 Bucket in the ElastiCache User Guide.    Error Message: The S3 bucket %s does not exist.  Solution: Create an Amazon S3 bucket in the same region as your snapshot. For more information, see Step 1: Create an Amazon S3 Bucket in the ElastiCache User Guide.    Error Message: The S3 bucket %s is not owned by the authenticated user.  Solution: Create an Amazon S3 bucket in the same region as your snapshot. For more information, see Step 1: Create an Amazon S3 Bucket in the ElastiCache User Guide.    Error Message: The authenticated user does not have sufficient permissions to perform the desired activity.  Solution: Contact your system administrator to get the needed permissions.    Error Message: The S3 bucket %s already contains an object with key %s.  Solution: Give the TargetSnapshotName a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for TargetSnapshotName.    Error Message:  ElastiCache has not been granted READ permissions %s on the S3 Bucket.  Solution: Add List and Read permissions on the bucket. For more information, see Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.    Error Message:  ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.  Solution: Add Upload/Delete permissions on the bucket. For more information, see Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.    Error Message:  ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.  Solution: Add View Permissions on the bucket. For more information, see Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket in the ElastiCache User Guide.

    Args:
        source_snapshot_name(str): The name of an existing snapshot from which to make a copy.
        target_snapshot_name(str): A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
        target_bucket(str, optional): The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access. When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket in the Amazon ElastiCache User Guide. For more information, see Exporting a Snapshot in the Amazon ElastiCache User Guide. Defaults to None.
        kms_key_id(str, optional): The ID of the KMS key used to encrypt the target snapshot. Defaults to None.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.snapshot.copy(
                ctx, source_snapshot_name=value, target_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.snapshot.copy source_snapshot_name=value, target_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="copy_snapshot",
        op_kwargs={
            "SourceSnapshotName": source_snapshot_name,
            "TargetSnapshotName": target_snapshot_name,
            "TargetBucket": target_bucket,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
        },
    )


async def create(
    hub,
    ctx,
    snapshot_name: str,
    replication_group_id: str = None,
    cache_cluster_id: str = None,
    kms_key_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a copy of an entire cluster or replication group at a specific moment in time.  This operation is valid for Redis only.

    Args:
        replication_group_id(str, optional): The identifier of an existing replication group. The snapshot is created from this replication group. Defaults to None.
        cache_cluster_id(str, optional): The identifier of an existing cluster. The snapshot is created from this cluster. Defaults to None.
        snapshot_name(str): A name for the snapshot being created.
        kms_key_id(str, optional): The ID of the KMS key used to encrypt the snapshot. Defaults to None.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.snapshot.create(ctx, snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.snapshot.create snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_snapshot",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "CacheClusterId": cache_cluster_id,
            "SnapshotName": snapshot_name,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.  This operation is valid for Redis only.

    Args:
        snapshot_name(str): The name of the snapshot to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.snapshot.delete(ctx, snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.snapshot.delete snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_snapshot",
        op_kwargs={"SnapshotName": snapshot_name},
    )


async def describe_all(
    hub,
    ctx,
    replication_group_id: str = None,
    cache_cluster_id: str = None,
    snapshot_name: str = None,
    snapshot_source: str = None,
    marker: str = None,
    max_records: int = None,
    show_node_group_config: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about cluster or replication group snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.  This operation is valid for Redis only.

    Args:
        replication_group_id(str, optional): A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described. Defaults to None.
        cache_cluster_id(str, optional): A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described. Defaults to None.
        snapshot_name(str, optional): A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described. Defaults to None.
        snapshot_source(str, optional): If set to system, the output shows snapshots that were automatically created by ElastiCache. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 50 Constraints: minimum 20; maximum 50. Defaults to None.
        show_node_group_config(bool, optional): A Boolean value which if true, the node group (shard) configuration is included in the snapshot description. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.snapshot.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.snapshot.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_snapshots",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "CacheClusterId": cache_cluster_id,
            "SnapshotName": snapshot_name,
            "SnapshotSource": snapshot_source,
            "Marker": marker,
            "MaxRecords": max_records,
            "ShowNodeGroupConfig": show_node_group_config,
        },
    )
