"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def rebalance(
    hub, ctx, global_replication_group_id: str, apply_immediately: bool
) -> Dict:
    r"""
    **Autogenerated function**

    Redistribute slots to ensure uniform distribution across existing shards in the cluster.

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        apply_immediately(bool): If True, redistribution is applied immediately.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.slot_in_global_replication_group.rebalance(
                ctx, global_replication_group_id=value, apply_immediately=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.slot_in_global_replication_group.rebalance global_replication_group_id=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="rebalance_slots_in_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "ApplyImmediately": apply_immediately,
        },
    )
