"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    service_update_name: str = None,
    service_update_status: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns details of the service updates

    Args:
        service_update_name(str, optional): The unique ID of the service update. Defaults to None.
        service_update_status(List, optional): The status of the service update. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.service_update.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.service_update.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_service_updates",
        op_kwargs={
            "ServiceUpdateName": service_update_name,
            "ServiceUpdateStatus": service_update_status,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
