"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def modify(
    hub,
    ctx,
    replication_group_id: str,
    node_group_count: int,
    apply_immediately: bool,
    resharding_configuration: List = None,
    node_groups_to_remove: List = None,
    node_groups_to_retain: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.

    Args:
        replication_group_id(str): The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.
        node_group_count(int): The number of node groups (shards) that results from the modification of the shard configuration.
        apply_immediately(bool): Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. Value: true.
        resharding_configuration(List, optional): Specifies the preferred availability zones for each node group in the cluster. If the value of NodeGroupCount is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you. You can specify this parameter only if the value of NodeGroupCount is greater than the current number of node groups (shards). Defaults to None.
        node_groups_to_remove(List, optional): If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove from the cluster. Defaults to None.
        node_groups_to_retain(List, optional): If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRetain is a list of NodeGroupIds to retain in the cluster. ElastiCache for Redis will attempt to remove all node groups except those listed by NodeGroupsToRetain from the cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.replication_group.shard_configuration.modify(
                ctx, replication_group_id=value, node_group_count=value, apply_immediately=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.replication_group.shard_configuration.modify replication_group_id=value, node_group_count=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_replication_group_shard_configuration",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "NodeGroupCount": node_group_count,
            "ApplyImmediately": apply_immediately,
            "ReshardingConfiguration": resharding_configuration,
            "NodeGroupsToRemove": node_groups_to_remove,
            "NodeGroupsToRetain": node_groups_to_retain,
        },
    )
