"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def decrease(
    hub,
    ctx,
    replication_group_id: str,
    apply_immediately: bool,
    new_replica_count: int = None,
    replica_configuration: List = None,
    replicas_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.

    Args:
        replication_group_id(str): The id of the replication group from which you want to remove replica nodes.
        new_replica_count(int, optional): The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups. The minimum number of replicas in a shard or replication group is:   Redis (cluster mode disabled)   If Multi-AZ is enabled: 1   If Multi-AZ is not enabled: 0     Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)  . Defaults to None.
        replica_configuration(List, optional): A list of ConfigureShard objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The ConfigureShard has three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones. Defaults to None.
        replicas_to_remove(List, optional): A list of the node ids to remove from the replication group or node group (shard). Defaults to None.
        apply_immediately(bool): If True, the number of replica nodes is decreased immediately. ApplyImmediately=False is not currently supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.replica.count.decrease(
                ctx, replication_group_id=value, apply_immediately=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.replica.count.decrease replication_group_id=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="decrease_replica_count",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "NewReplicaCount": new_replica_count,
            "ReplicaConfiguration": replica_configuration,
            "ReplicasToRemove": replicas_to_remove,
            "ApplyImmediately": apply_immediately,
        },
    )


async def increase(
    hub,
    ctx,
    replication_group_id: str,
    apply_immediately: bool,
    new_replica_count: int = None,
    replica_configuration: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.

    Args:
        replication_group_id(str): The id of the replication group to which you want to add replica nodes.
        new_replica_count(int, optional): The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups. Defaults to None.
        replica_configuration(List, optional): A list of ConfigureShard objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The ConfigureShard has three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones. Defaults to None.
        apply_immediately(bool): If True, the number of replica nodes is increased immediately. ApplyImmediately=False is not currently supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.replica.count.increase(
                ctx, replication_group_id=value, apply_immediately=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.replica.count.increase replication_group_id=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="increase_replica_count",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "NewReplicaCount": new_replica_count,
            "ReplicaConfiguration": replica_configuration,
            "ApplyImmediately": apply_immediately,
        },
    )
