"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def decrease(
    hub,
    ctx,
    global_replication_group_id: str,
    node_group_count: int,
    apply_immediately: bool,
    global_node_groups_to_remove: List = None,
    global_node_groups_to_retain: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Decreases the number of node groups in a Global datastore

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        node_group_count(int): The number of node groups (shards) that results from the modification of the shard configuration.
        global_node_groups_to_remove(List, optional): If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. . Defaults to None.
        global_node_groups_to_retain(List, optional): If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. . Defaults to None.
        apply_immediately(bool): Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.node_group_in_global_replication_group.decrease(
                ctx,
                global_replication_group_id=value,
                node_group_count=value,
                apply_immediately=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.node_group_in_global_replication_group.decrease global_replication_group_id=value, node_group_count=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="decrease_node_groups_in_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "NodeGroupCount": node_group_count,
            "GlobalNodeGroupsToRemove": global_node_groups_to_remove,
            "GlobalNodeGroupsToRetain": global_node_groups_to_retain,
            "ApplyImmediately": apply_immediately,
        },
    )


async def increase(
    hub,
    ctx,
    global_replication_group_id: str,
    node_group_count: int,
    apply_immediately: bool,
    regional_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Increase the number of node groups in the Global datastore

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        node_group_count(int): The number of node groups you wish to add.
        regional_configurations(List, optional): Describes the replication group IDs, the AWS regions where they are stored and the shard configuration for each that comprise the Global datastore. Defaults to None.
        apply_immediately(bool): Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.node_group_in_global_replication_group.increase(
                ctx,
                global_replication_group_id=value,
                node_group_count=value,
                apply_immediately=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.node_group_in_global_replication_group.increase global_replication_group_id=value, node_group_count=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="increase_node_groups_in_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "NodeGroupCount": node_group_count,
            "RegionalConfigurations": regional_configurations,
            "ApplyImmediately": apply_immediately,
        },
    )
