"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def complete(hub, ctx, replication_group_id: str, force: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Complete the migration of data.

    Args:
        replication_group_id(str): The ID of the replication group to which data is being migrated.
        force(bool, optional): Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.migration.complete(ctx, replication_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.migration.complete replication_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="complete_migration",
        op_kwargs={"ReplicationGroupId": replication_group_id, "Force": force},
    )


async def start(
    hub, ctx, replication_group_id: str, customer_node_endpoint_list: List
) -> Dict:
    r"""
    **Autogenerated function**

    Start the migration of data.

    Args:
        replication_group_id(str): The ID of the replication group to which data should be migrated.
        customer_node_endpoint_list(List): List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.migration.start(
                ctx, replication_group_id=value, customer_node_endpoint_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.migration.start replication_group_id=value, customer_node_endpoint_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="start_migration",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "CustomerNodeEndpointList": customer_node_endpoint_list,
        },
    )
