"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    global_replication_group_id_suffix: str,
    primary_replication_group_id: str,
    global_replication_group_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see Replication Across Regions Using Global Datastore.    The GlobalReplicationGroupIdSuffix is the name of the Global datastore.   The PrimaryReplicationGroupId represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.

    Args:
        global_replication_group_id_suffix(str): The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each AWS Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions.  For a full list of AWS Regions and their respective Global datastore iD prefixes, see Using the AWS CLI with Global datastores .
        global_replication_group_description(str, optional): Provides details of the Global datastore. Defaults to None.
        primary_replication_group_id(str): The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.create(
                ctx, global_replication_group_id_suffix=value, primary_replication_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.create global_replication_group_id_suffix=value, primary_replication_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupIdSuffix": global_replication_group_id_suffix,
            "GlobalReplicationGroupDescription": global_replication_group_description,
            "PrimaryReplicationGroupId": primary_replication_group_id,
        },
    )


async def delete(
    hub, ctx, global_replication_group_id: str, retain_primary_replication_group: bool
) -> Dict:
    r"""
    **Autogenerated function**

    Deleting a Global datastore is a two-step process:    First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.   Once the Global datastore contains only the primary cluster, you can use the DeleteGlobalReplicationGroup API to delete the Global datastore while retainining the primary cluster using RetainPrimaryReplicationGroup=true.   Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting RetainPrimaryReplicationGroup=true. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        retain_primary_replication_group(bool): The primary replication group is retained as a standalone replication group. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.delete(
                ctx, global_replication_group_id=value, retain_primary_replication_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.delete global_replication_group_id=value, retain_primary_replication_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "RetainPrimaryReplicationGroup": retain_primary_replication_group,
        },
    )


async def describe_all(
    hub,
    ctx,
    global_replication_group_id: str = None,
    max_records: int = None,
    marker: str = None,
    show_member_info: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.

    Args:
        global_replication_group_id(str, optional): The name of the Global datastore. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. . Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        show_member_info(bool, optional): Returns the list of members that comprise the Global datastore. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_global_replication_groups",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "MaxRecords": max_records,
            "Marker": marker,
            "ShowMemberInfo": show_member_info,
        },
    )


async def disassociate(
    hub,
    ctx,
    global_replication_group_id: str,
    replication_group_id: str,
    replication_group_region: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that AWS region.

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        replication_group_id(str): The name of the secondary cluster you wish to remove from the Global datastore.
        replication_group_region(str): The AWS region of secondary cluster you wish to remove from the Global datastore.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.disassociate(
                ctx,
                global_replication_group_id=value,
                replication_group_id=value,
                replication_group_region=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.disassociate global_replication_group_id=value, replication_group_id=value, replication_group_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="disassociate_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "ReplicationGroupId": replication_group_id,
            "ReplicationGroupRegion": replication_group_region,
        },
    )


async def failover(
    hub,
    ctx,
    global_replication_group_id: str,
    primary_region: str,
    primary_replication_group_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to failover the primary region to a selected secondary region. The selected secondary region will become primary, and all other clusters will become secondary.

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        primary_region(str): The AWS region of the primary cluster of the Global datastore.
        primary_replication_group_id(str): The name of the primary replication group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.failover(
                ctx,
                global_replication_group_id=value,
                primary_region=value,
                primary_replication_group_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.failover global_replication_group_id=value, primary_region=value, primary_replication_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="failover_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "PrimaryRegion": primary_region,
            "PrimaryReplicationGroupId": primary_replication_group_id,
        },
    )


async def modify(
    hub,
    ctx,
    global_replication_group_id: str,
    apply_immediately: bool,
    cache_node_type: str = None,
    engine_version: str = None,
    cache_parameter_group_name: str = None,
    global_replication_group_description: str = None,
    automatic_failover_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for a Global datastore.

    Args:
        global_replication_group_id(str): The name of the Global datastore.
        apply_immediately(bool): This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. .
        cache_node_type(str, optional): A valid cache node type that you want to scale this Global datastore to. Defaults to None.
        engine_version(str, optional): The upgraded version of the cache engine to be run on the clusters in the Global datastore. . Defaults to None.
        cache_parameter_group_name(str, optional): The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore. Defaults to None.
        global_replication_group_description(str, optional): A description of the Global datastore. Defaults to None.
        automatic_failover_enabled(bool, optional): Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.global_replication_group.modify(
                ctx, global_replication_group_id=value, apply_immediately=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.global_replication_group.modify global_replication_group_id=value, apply_immediately=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_global_replication_group",
        op_kwargs={
            "GlobalReplicationGroupId": global_replication_group_id,
            "ApplyImmediately": apply_immediately,
            "CacheNodeType": cache_node_type,
            "EngineVersion": engine_version,
            "CacheParameterGroupName": cache_parameter_group_name,
            "GlobalReplicationGroupDescription": global_replication_group_description,
            "AutomaticFailoverEnabled": automatic_failover_enabled,
        },
    )
