"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(hub, ctx, replication_group_id: str, node_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Represents the input of a TestFailover operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).  Note the following    A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and AWS CLI) in any rolling 24-hour period.   If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.     If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.   To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the AWS CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:   Replication group message: Test Failover API called for node group <node-group-id>    Cache cluster message: Failover from primary node <primary-node-id> to replica node <node-id> completed    Replication group message: Failover from primary node <primary-node-id> to replica node <node-id> completed    Cache cluster message: Recovering cache nodes <node-id>    Cache cluster message: Finished recovery for cache nodes <node-id>    For more information see:    Viewing ElastiCache Events in the ElastiCache User Guide     DescribeEvents in the ElastiCache API Reference     Also see, Testing Multi-AZ  in the ElastiCache User Guide.

    Args:
        replication_group_id(str): The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.
        node_group_id(str): The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.failover.test(
                ctx, replication_group_id=value, node_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.failover.test replication_group_id=value, node_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="test_failover",
        op_kwargs={
            "ReplicationGroupId": replication_group_id,
            "NodeGroupId": node_group_id,
        },
    )
