"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    cache_parameter_group_family: str,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the default engine and system parameter information for the specified cache engine.

    Args:
        cache_parameter_group_family(str): The name of the cache parameter group family. Valid values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | .
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.engine_default_parameter.describe_all(
                ctx, cache_parameter_group_family=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.engine_default_parameter.describe_all cache_parameter_group_family=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_engine_default_parameters",
        op_kwargs={
            "CacheParameterGroupFamily": cache_parameter_group_family,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
