"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cache_subnet_group_name: str,
    cache_subnet_group_description: str,
    subnet_ids: List,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cache subnet group. Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).

    Args:
        cache_subnet_group_name(str): A name for the cache subnet group. This value is stored as a lowercase string. Constraints: Must contain no more than 255 alphanumeric characters or hyphens. Example: mysubnetgroup .
        cache_subnet_group_description(str): A description for the cache subnet group.
        subnet_ids(List): A list of VPC subnet IDs for the cache subnet group.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.subnet_group.create(
                ctx,
                cache_subnet_group_name=value,
                cache_subnet_group_description=value,
                subnet_ids=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.subnet_group.create cache_subnet_group_name=value, cache_subnet_group_description=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_cache_subnet_group",
        op_kwargs={
            "CacheSubnetGroupName": cache_subnet_group_name,
            "CacheSubnetGroupDescription": cache_subnet_group_description,
            "SubnetIds": subnet_ids,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, cache_subnet_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a cache subnet group.  You cannot delete a default cache subnet group or one that is associated with any clusters.

    Args:
        cache_subnet_group_name(str): The name of the cache subnet group to delete. Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.subnet_group.delete(
                ctx, cache_subnet_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.subnet_group.delete cache_subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_cache_subnet_group",
        op_kwargs={"CacheSubnetGroupName": cache_subnet_group_name},
    )


async def describe_all(
    hub,
    ctx,
    cache_subnet_group_name: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.

    Args:
        cache_subnet_group_name(str, optional): The name of the cache subnet group to return details for. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.subnet_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.subnet_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_cache_subnet_groups",
        op_kwargs={
            "CacheSubnetGroupName": cache_subnet_group_name,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    cache_subnet_group_name: str,
    cache_subnet_group_description: str = None,
    subnet_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an existing cache subnet group.

    Args:
        cache_subnet_group_name(str): The name for the cache subnet group. This value is stored as a lowercase string. Constraints: Must contain no more than 255 alphanumeric characters or hyphens. Example: mysubnetgroup .
        cache_subnet_group_description(str, optional): A description of the cache subnet group. Defaults to None.
        subnet_ids(List, optional): The EC2 subnet IDs for the cache subnet group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.subnet_group.modify(
                ctx, cache_subnet_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.subnet_group.modify cache_subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_cache_subnet_group",
        op_kwargs={
            "CacheSubnetGroupName": cache_subnet_group_name,
            "CacheSubnetGroupDescription": cache_subnet_group_description,
            "SubnetIds": subnet_ids,
        },
    )
