"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, cache_security_group_name: str, description: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cache security group. Use a cache security group to control access to one or more clusters. Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see CreateCacheSubnetGroup.

    Args:
        cache_security_group_name(str): A name for the cache security group. This value is stored as a lowercase string. Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default". Example: mysecuritygroup .
        description(str): A description for the cache security group.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.security_group.init.create(
                ctx, cache_security_group_name=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.security_group.init.create cache_security_group_name=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_cache_security_group",
        op_kwargs={
            "CacheSecurityGroupName": cache_security_group_name,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, cache_security_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a cache security group.  You cannot delete a cache security group if it is associated with any clusters.

    Args:
        cache_security_group_name(str): The name of the cache security group to delete.  You cannot delete the default security group. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.security_group.init.delete(
                ctx, cache_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.security_group.init.delete cache_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_cache_security_group",
        op_kwargs={"CacheSecurityGroupName": cache_security_group_name},
    )


async def describe_all(
    hub,
    ctx,
    cache_security_group_name: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup

    Args:
        cache_security_group_name(str, optional): The name of the cache security group to return details for. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.security_group.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.security_group.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_cache_security_groups",
        op_kwargs={
            "CacheSecurityGroupName": cache_security_group_name,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
