"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(
    hub,
    ctx,
    cache_security_group_name: str,
    ec2_security_group_name: str,
    ec2_security_group_owner_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.  You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.

    Args:
        cache_security_group_name(str): The cache security group that allows network ingress.
        ec2_security_group_name(str): The Amazon EC2 security group to be authorized for ingress to the cache security group.
        ec2_security_group_owner_id(str): The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS access key ID - you must provide a valid AWS account number for this parameter.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.security_group.ingress.authorize(
                ctx,
                cache_security_group_name=value,
                ec2_security_group_name=value,
                ec2_security_group_owner_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.security_group.ingress.authorize cache_security_group_name=value, ec2_security_group_name=value, ec2_security_group_owner_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="authorize_cache_security_group_ingress",
        op_kwargs={
            "CacheSecurityGroupName": cache_security_group_name,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )


async def revoke(
    hub,
    ctx,
    cache_security_group_name: str,
    ec2_security_group_name: str,
    ec2_security_group_owner_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.

    Args:
        cache_security_group_name(str): The name of the cache security group to revoke ingress from.
        ec2_security_group_name(str): The name of the Amazon EC2 security group to revoke access from.
        ec2_security_group_owner_id(str): The AWS account number of the Amazon EC2 security group owner. Note that this is not the same thing as an AWS access key ID - you must provide a valid AWS account number for this parameter.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.security_group.ingress.revoke(
                ctx,
                cache_security_group_name=value,
                ec2_security_group_name=value,
                ec2_security_group_owner_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.security_group.ingress.revoke cache_security_group_name=value, ec2_security_group_name=value, ec2_security_group_owner_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="revoke_cache_security_group_ingress",
        op_kwargs={
            "CacheSecurityGroupName": cache_security_group_name,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )
