"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cache_parameter_group_name: str,
    cache_parameter_group_family: str,
    description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup. A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:    ModifyCacheParameterGroup in the ElastiCache API Reference.    Parameters and Parameter Groups in the ElastiCache User Guide.

    Args:
        cache_parameter_group_name(str): A user-specified name for the cache parameter group.
        cache_parameter_group_family(str): The name of the cache parameter group family that the cache parameter group can be used with. Valid values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | .
        description(str): A user-specified description for the cache parameter group.
        tags(List, optional): A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.parameter.group.create(
                ctx,
                cache_parameter_group_name=value,
                cache_parameter_group_family=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.parameter.group.create cache_parameter_group_name=value, cache_parameter_group_family=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_cache_parameter_group",
        op_kwargs={
            "CacheParameterGroupName": cache_parameter_group_name,
            "CacheParameterGroupFamily": cache_parameter_group_family,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, cache_parameter_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.

    Args:
        cache_parameter_group_name(str): The name of the cache parameter group to delete.  The specified cache security group must not be associated with any clusters. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.parameter.group.delete(
                ctx, cache_parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.parameter.group.delete cache_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_cache_parameter_group",
        op_kwargs={"CacheParameterGroupName": cache_parameter_group_name},
    )


async def describe_all(
    hub,
    ctx,
    cache_parameter_group_name: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.

    Args:
        cache_parameter_group_name(str, optional): The name of a specific cache parameter group to return details for. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.parameter.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.parameter.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_cache_parameter_groups",
        op_kwargs={
            "CacheParameterGroupName": cache_parameter_group_name,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub, ctx, cache_parameter_group_name: str, parameter_name_values: List
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.

    Args:
        cache_parameter_group_name(str): The name of the cache parameter group to modify.
        parameter_name_values(List): An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.parameter.group.modify(
                ctx, cache_parameter_group_name=value, parameter_name_values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.parameter.group.modify cache_parameter_group_name=value, parameter_name_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_cache_parameter_group",
        op_kwargs={
            "CacheParameterGroupName": cache_parameter_group_name,
            "ParameterNameValues": parameter_name_values,
        },
    )


async def reset(
    hub,
    ctx,
    cache_parameter_group_name: str,
    reset_all_parameters: bool = None,
    parameter_name_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the ResetAllParameters and CacheParameterGroupName parameters.

    Args:
        cache_parameter_group_name(str): The name of the cache parameter group to reset.
        reset_all_parameters(bool, optional): If true, all parameters in the cache parameter group are reset to their default values. If false, only the parameters listed by ParameterNameValues are reset to their default values. Valid values: true | false . Defaults to None.
        parameter_name_values(List, optional): An array of parameter names to reset to their default values. If ResetAllParameters is true, do not use ParameterNameValues. If ResetAllParameters is false, you must specify the name of at least one parameter to reset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.parameter.group.reset(
                ctx, cache_parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.parameter.group.reset cache_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="reset_cache_parameter_group",
        op_kwargs={
            "CacheParameterGroupName": cache_parameter_group_name,
            "ResetAllParameters": reset_all_parameters,
            "ParameterNameValues": parameter_name_values,
        },
    )
