"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    engine: str = None,
    engine_version: str = None,
    cache_parameter_group_family: str = None,
    max_records: int = None,
    marker: str = None,
    default_only: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the available cache engines and their versions.

    Args:
        engine(str, optional): The cache engine to return. Valid values: memcached | redis . Defaults to None.
        engine_version(str, optional): The cache engine version to return. Example: 1.4.14 . Defaults to None.
        cache_parameter_group_family(str, optional): The name of a specific cache parameter group family to return details for. Valid values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x |  Constraints:   Must be 1 to 255 alphanumeric characters   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens  . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        default_only(bool, optional): If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.engine_version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.engine_version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_cache_engine_versions",
        op_kwargs={
            "Engine": engine,
            "EngineVersion": engine_version,
            "CacheParameterGroupFamily": cache_parameter_group_family,
            "MaxRecords": max_records,
            "Marker": marker,
            "DefaultOnly": default_only,
        },
    )
