"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cache_cluster_id: str,
    replication_group_id: str = None,
    az_mode: str = None,
    preferred_availability_zone: str = None,
    preferred_availability_zones: List = None,
    num_cache_nodes: int = None,
    cache_node_type: str = None,
    engine: str = None,
    engine_version: str = None,
    cache_parameter_group_name: str = None,
    cache_subnet_group_name: str = None,
    cache_security_group_names: List = None,
    security_group_ids: List = None,
    tags: List = None,
    snapshot_arns: List = None,
    snapshot_name: str = None,
    preferred_maintenance_window: str = None,
    port: int = None,
    notification_topic_arn: str = None,
    auto_minor_version_upgrade: bool = None,
    snapshot_retention_limit: int = None,
    snapshot_window: str = None,
    auth_token: str = None,
    outpost_mode: str = None,
    preferred_outpost_arn: str = None,
    preferred_outpost_arns: List = None,
    log_delivery_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis. This operation is not supported for Redis (cluster mode enabled) clusters.

    Args:
        cache_cluster_id(str): The node group (shard) identifier. This parameter is stored as a lowercase string.  Constraints:    A name must contain from 1 to 50 alphanumeric characters or hyphens.   The first character must be a letter.   A name cannot end with a hyphen or contain two consecutive hyphens.  .
        replication_group_id(str, optional): The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group. If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.  This parameter is only valid if the Engine parameter is redis. . Defaults to None.
        az_mode(str, optional): Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. This parameter is only supported for Memcached clusters. If the AZMode and PreferredAvailabilityZones are not specified, ElastiCache assumes single-az mode. Defaults to None.
        preferred_availability_zone(str, optional): The EC2 Availability Zone in which the cluster is created. All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use PreferredAvailabilityZones. Default: System chosen Availability Zone. Defaults to None.
        preferred_availability_zones(List, optional): A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important. This option is only supported on Memcached.  If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of NumCacheNodes.  If you want all the nodes in the same Availability Zone, use PreferredAvailabilityZone instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Defaults to None.
        num_cache_nodes(int, optional): The initial number of cache nodes that the cluster has. For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40. If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at http://aws.amazon.com/contact-us/elasticache-node-limit-request/. Defaults to None.
        cache_node_type(str, optional): The compute and memory capacity of the nodes in the node group (shard). The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.   General purpose:   Current generation:   M6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).  cache.m6g.large, cache.m6g.xlarge, cache.m6g.2xlarge, cache.m6g.4xlarge, cache.m6g.8xlarge, cache.m6g.12xlarge, cache.m6g.16xlarge   For region availability, see Supported Node Types    M5 node types: cache.m5.large, cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge, cache.m5.24xlarge   M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge   T3 node types: cache.t3.micro, cache.t3.small, cache.t3.medium   T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium    Previous generation: (not recommended)  T1 node types: cache.t1.micro   M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge   M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge      Compute optimized:   Previous generation: (not recommended)  C1 node types: cache.c1.xlarge      Memory optimized:   Current generation:   R6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).  cache.r6g.large, cache.r6g.xlarge, cache.r6g.2xlarge, cache.r6g.4xlarge, cache.r6g.8xlarge, cache.r6g.12xlarge, cache.r6g.16xlarge   For region availability, see Supported Node Types    R5 node types: cache.r5.large, cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge, cache.r5.24xlarge   R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge    Previous generation: (not recommended)  M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge   R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge       Additional node type info    All current generation instance types are created in Amazon VPC by default.   Redis append-only files (AOF) are not supported for T1 or T2 instances.   Redis Multi-AZ with automatic failover is not supported on T1 instances.   Redis configuration variables appendonly and appendfsync are not supported on Redis version 2.8.22 and later.  . Defaults to None.
        engine(str, optional): The name of the cache engine to be used for this cluster. Valid values for this parameter are: memcached | redis . Defaults to None.
        engine_version(str, optional): The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.  Important: You can upgrade to a newer engine version (see Selecting a Cache Engine and Version), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. . Defaults to None.
        cache_parameter_group_name(str, optional): The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has cluster-enabled='yes' when creating a cluster. Defaults to None.
        cache_subnet_group_name(str, optional): The name of the subnet group to be used for the cluster. Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).  If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see Subnets and Subnet Groups. . Defaults to None.
        cache_security_group_names(List, optional): A list of security group names to associate with this cluster. Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). Defaults to None.
        security_group_ids(List, optional): One or more VPC security groups associated with the cluster. Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC). Defaults to None.
        tags(List, optional): A list of tags to be added to this resource. Defaults to None.
        snapshot_arns(List, optional): A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.  This parameter is only valid if the Engine parameter is redis.  Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb . Defaults to None.
        snapshot_name(str, optional): The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to restoring while the new node group (shard) is being created.  This parameter is only valid if the Engine parameter is redis. . Defaults to None.
        preferred_maintenance_window(str, optional): Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for ddd are:. Defaults to None.
        port(int, optional): The port number on which each of the cache nodes accepts connections. Defaults to None.
        notification_topic_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.  The Amazon SNS topic owner must be the same as the cluster owner. . Defaults to None.
        auto_minor_version_upgrade(bool, optional): This parameter is currently disabled. Defaults to None.
        snapshot_retention_limit(int, optional): The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot taken today is retained for 5 days before being deleted.  This parameter is only valid if the Engine parameter is redis.  Default: 0 (i.e., automatic backups are disabled for this cache cluster). Defaults to None.
        snapshot_window(str, optional): The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard). Example: 05:00-09:00  If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.  This parameter is only valid if the Engine parameter is redis. . Defaults to None.
        auth_token(str, optional):  Reserved parameter. The password used to access a password protected server. Password constraints:   Must be only printable ASCII characters.   Must be at least 16 characters and no more than 128 characters in length.   The only permitted printable special characters are !, &, #, $, ^, <, >, and -. Other printable special characters cannot be used in the AUTH token.   For more information, see AUTH password at http://redis.io/commands/AUTH. Defaults to None.
        outpost_mode(str, optional): Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts. Defaults to None.
        preferred_outpost_arn(str, optional): The outpost ARN in which the cache cluster is created. Defaults to None.
        preferred_outpost_arns(List, optional): The outpost ARNs in which the cache cluster is created. Defaults to None.
        log_delivery_configurations(List, optional): Specifies the destination, format and type of the logs. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.cluster.create(ctx, cache_cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.cluster.create cache_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="create_cache_cluster",
        op_kwargs={
            "CacheClusterId": cache_cluster_id,
            "ReplicationGroupId": replication_group_id,
            "AZMode": az_mode,
            "PreferredAvailabilityZone": preferred_availability_zone,
            "PreferredAvailabilityZones": preferred_availability_zones,
            "NumCacheNodes": num_cache_nodes,
            "CacheNodeType": cache_node_type,
            "Engine": engine,
            "EngineVersion": engine_version,
            "CacheParameterGroupName": cache_parameter_group_name,
            "CacheSubnetGroupName": cache_subnet_group_name,
            "CacheSecurityGroupNames": cache_security_group_names,
            "SecurityGroupIds": security_group_ids,
            "Tags": tags,
            "SnapshotArns": snapshot_arns,
            "SnapshotName": snapshot_name,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "Port": port,
            "NotificationTopicArn": notification_topic_arn,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "SnapshotRetentionLimit": snapshot_retention_limit,
            "SnapshotWindow": snapshot_window,
            "AuthToken": auth_token,
            "OutpostMode": outpost_mode,
            "PreferredOutpostArn": preferred_outpost_arn,
            "PreferredOutpostArns": preferred_outpost_arns,
            "LogDeliveryConfigurations": log_delivery_configurations,
        },
    )


async def delete(
    hub, ctx, cache_cluster_id: str, final_snapshot_identifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a previously provisioned cluster. DeleteCacheCluster deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation. This operation is not valid for:   Redis (cluster mode enabled) clusters   Redis (cluster mode disabled) clusters   A cluster that is the last read replica of a replication group   A cluster that is the primary node of a replication group   A node group (shard) that has Multi-AZ mode enabled   A cluster from a Redis (cluster mode enabled) replication group   A cluster that is not in the available state

    Args:
        cache_cluster_id(str): The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.
        final_snapshot_identifier(str, optional): The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.cluster.delete(ctx, cache_cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.cluster.delete cache_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="delete_cache_cluster",
        op_kwargs={
            "CacheClusterId": cache_cluster_id,
            "FinalSnapshotIdentifier": final_snapshot_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    cache_cluster_id: str = None,
    max_records: int = None,
    marker: str = None,
    show_cache_node_info: bool = None,
    show_cache_clusters_not_in_replication_groups: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied. By default, abbreviated information about the clusters is returned. You can use the optional ShowCacheNodeInfo flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint. If the cluster is in the creating state, only cluster-level information is displayed until all of the nodes are successfully provisioned. If the cluster is in the deleting state, only cluster-level information is displayed. If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is available, the cluster is ready for use. If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.

    Args:
        cache_cluster_id(str, optional): The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: minimum 20; maximum 100. Defaults to None.
        marker(str, optional): An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        show_cache_node_info(bool, optional): An optional flag that can be included in the DescribeCacheCluster request to retrieve information about the individual cache nodes. Defaults to None.
        show_cache_clusters_not_in_replication_groups(bool, optional): An optional flag that can be included in the DescribeCacheCluster request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="describe_cache_clusters",
        op_kwargs={
            "CacheClusterId": cache_cluster_id,
            "MaxRecords": max_records,
            "Marker": marker,
            "ShowCacheNodeInfo": show_cache_node_info,
            "ShowCacheClustersNotInReplicationGroups": show_cache_clusters_not_in_replication_groups,
        },
    )


async def modify(
    hub,
    ctx,
    cache_cluster_id: str,
    num_cache_nodes: int = None,
    cache_node_ids_to_remove: List = None,
    az_mode: str = None,
    new_availability_zones: List = None,
    cache_security_group_names: List = None,
    security_group_ids: List = None,
    preferred_maintenance_window: str = None,
    notification_topic_arn: str = None,
    cache_parameter_group_name: str = None,
    notification_topic_status: str = None,
    apply_immediately: bool = None,
    engine_version: str = None,
    auto_minor_version_upgrade: bool = None,
    snapshot_retention_limit: int = None,
    snapshot_window: str = None,
    cache_node_type: str = None,
    auth_token: str = None,
    auth_token_update_strategy: str = None,
    log_delivery_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.

    Args:
        cache_cluster_id(str): The cluster identifier. This value is stored as a lowercase string.
        num_cache_nodes(int, optional): The number of cache nodes that the cluster should have. If the value for NumCacheNodes is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled. If you are removing cache nodes, you must use the CacheNodeIdsToRemove parameter to provide the IDs of the specific cache nodes to remove. For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.  Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see ApplyImmediately). A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the ModifyCacheCluster request and set NumCacheNodes equal to the number of cache nodes currently in the cluster. . Defaults to None.
        cache_node_ids_to_remove(List, optional): A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when NumCacheNodes is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of NumCacheNodes in the request. For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this ModifyCacheCluster call is 5, you must list 2 (7 - 5) cache node IDs to remove. Defaults to None.
        az_mode(str, optional): Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones. Valid values: single-az | cross-az. This option is only supported for Memcached clusters.  You cannot specify single-az if the Memcached cluster already has cache nodes in different Availability Zones. If cross-az is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes are located in different Availability Zones.  . Defaults to None.
        new_availability_zones(List, optional):  This option is only supported on Memcached clusters.  The list of Availability Zones where the new Memcached cache nodes are created. This parameter is only valid when NumCacheNodes in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request. Scenarios:    Scenario 1: You have 3 active nodes and wish to add 2 nodes. Specify NumCacheNodes=5 (3 + 2) and optionally specify two Availability Zones for the two new nodes.    Scenario 2: You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify NumCacheNodes=6 ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.    Scenario 3: You want to cancel all pending operations. Specify NumCacheNodes=3 to cancel all pending operations.   The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting NumCacheNodes to the number of current nodes. If cross-az is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the Availability Zone Considerations section of Cache Node Considerations for Memcached.  Impact of new add/remove requests upon pending requests    Scenario-1   Pending Action: Delete   New Request: Delete   Result: The new delete, pending or immediate, replaces the pending delete.     Scenario-2   Pending Action: Delete   New Request: Create   Result: The new create, pending or immediate, replaces the pending delete.     Scenario-3   Pending Action: Create   New Request: Delete   Result: The new delete, pending or immediate, replaces the pending create.     Scenario-4   Pending Action: Create   New Request: Create   Result: The new create is added to the pending create.   Important: If the new create request is Apply Immediately - Yes, all creates are performed immediately. If the new create request is Apply Immediately - No, all creates are pending.     . Defaults to None.
        cache_security_group_names(List, optional): A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible. You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC). Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default". Defaults to None.
        security_group_ids(List, optional): Specifies the VPC Security Groups associated with the cluster. This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC). Defaults to None.
        preferred_maintenance_window(str, optional): Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for ddd are:    sun     mon     tue     wed     thu     fri     sat    Example: sun:23:00-mon:01:30 . Defaults to None.
        notification_topic_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.  The Amazon SNS topic owner must be same as the cluster owner. . Defaults to None.
        cache_parameter_group_name(str, optional): The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the ApplyImmediately parameter is specified as true for this request. Defaults to None.
        notification_topic_status(str, optional): The status of the Amazon SNS notification topic. Notifications are sent only if the status is active. Valid values: active | inactive . Defaults to None.
        apply_immediately(bool, optional): If true, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the PreferredMaintenanceWindow setting for the cluster. If false, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.  If you perform a ModifyCacheCluster before a pending modification is applied, the pending modification is replaced by the newer modification.  Valid values: true | false  Default: false . Defaults to None.
        engine_version(str, optional): The upgraded version of the cache engine to be run on the cache nodes.  Important: You can upgrade to a newer engine version (see Selecting a Cache Engine and Version), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. . Defaults to None.
        auto_minor_version_upgrade(bool, optional): This parameter is currently disabled. Defaults to None.
        snapshot_retention_limit(int, optional): The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.  If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. . Defaults to None.
        snapshot_window(str, optional): The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. . Defaults to None.
        cache_node_type(str, optional): A valid cache node type that you want to scale this cluster up to. Defaults to None.
        auth_token(str, optional): Reserved parameter. The password used to access a password protected server. This parameter must be specified with the auth-token-update parameter. Password constraints:   Must be only printable ASCII characters   Must be at least 16 characters and no more than 128 characters in length   Cannot contain any of the following characters: '/', '"', or '@', '%'    For more information, see AUTH password at AUTH. Defaults to None.
        auth_token_update_strategy(str, optional): Specifies the strategy to use to update the AUTH token. This parameter must be specified with the auth-token parameter. Possible values:   Rotate   Set    For more information, see Authenticating Users with Redis AUTH . Defaults to None.
        log_delivery_configurations(List, optional): Specifies the destination, format and type of the logs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.cluster.modify(ctx, cache_cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.cluster.modify cache_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="modify_cache_cluster",
        op_kwargs={
            "CacheClusterId": cache_cluster_id,
            "NumCacheNodes": num_cache_nodes,
            "CacheNodeIdsToRemove": cache_node_ids_to_remove,
            "AZMode": az_mode,
            "NewAvailabilityZones": new_availability_zones,
            "CacheSecurityGroupNames": cache_security_group_names,
            "SecurityGroupIds": security_group_ids,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "NotificationTopicArn": notification_topic_arn,
            "CacheParameterGroupName": cache_parameter_group_name,
            "NotificationTopicStatus": notification_topic_status,
            "ApplyImmediately": apply_immediately,
            "EngineVersion": engine_version,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "SnapshotRetentionLimit": snapshot_retention_limit,
            "SnapshotWindow": snapshot_window,
            "CacheNodeType": cache_node_type,
            "AuthToken": auth_token,
            "AuthTokenUpdateStrategy": auth_token_update_strategy,
            "LogDeliveryConfigurations": log_delivery_configurations,
        },
    )


async def reboot(
    hub, ctx, cache_cluster_id: str, cache_node_ids_to_reboot: List
) -> Dict:
    r"""
    **Autogenerated function**

    Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING. The reboot causes the contents of the cache (for each cache node being rebooted) to be lost. When the reboot is complete, a cluster event is created. Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters. If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see Rebooting a Cluster for an alternate process.

    Args:
        cache_cluster_id(str): The cluster identifier. This parameter is stored as a lowercase string.
        cache_node_ids_to_reboot(List): A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.cache.cluster.reboot(
                ctx, cache_cluster_id=value, cache_node_ids_to_reboot=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.cache.cluster.reboot cache_cluster_id=value, cache_node_ids_to_reboot=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="reboot_cache_cluster",
        op_kwargs={
            "CacheClusterId": cache_cluster_id,
            "CacheNodeIdsToReboot": cache_node_ids_to_reboot,
        },
    )
