"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    service_update_name: str,
    replication_group_ids: List = None,
    cache_cluster_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Apply the service update. For more information on service updates and applying them, see Applying Service Updates.

    Args:
        replication_group_ids(List, optional): The replication group IDs. Defaults to None.
        cache_cluster_ids(List, optional): The cache cluster IDs. Defaults to None.
        service_update_name(str): The unique ID of the service update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elasticache.apply_update_action.batch(
                ctx, service_update_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elasticache.apply_update_action.batch service_update_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elasticache",
        operation="batch_apply_update_action",
        op_kwargs={
            "ReplicationGroupIds": replication_group_ids,
            "CacheClusterIds": cache_cluster_ids,
            "ServiceUpdateName": service_update_name,
        },
    )
