"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastic_inference.accelerator.type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastic_inference.accelerator.type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastic-inference",
        operation="describe_accelerator_types",
        op_kwargs={},
    )
