"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, location_type: str, accelerator_types: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describes the locations in which a given accelerator type or set of types is present in a given region.

    Args:
        location_type(str):  The location type that you want to describe accelerator type offerings for. It can assume the following values: region: will return the accelerator type offering at the regional level. availability-zone: will return the accelerator type offering at the availability zone level. availability-zone-id: will return the accelerator type offering at the availability zone level returning the availability zone id. .
        accelerator_types(List, optional):  The list of accelerator types to describe. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastic_inference.accelerator.offering.describe_all(
                ctx, location_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastic_inference.accelerator.offering.describe_all location_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastic-inference",
        operation="describe_accelerator_offerings",
        op_kwargs={
            "locationType": location_type,
            "acceleratorTypes": accelerator_types,
        },
    )
