"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    accelerator_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Describes information over a provided set of accelerators belonging to an account.

    Args:
        accelerator_ids(List, optional):  The IDs of the accelerators to describe. . Defaults to None.
        filters(List, optional):  One or more filters. Filter names and values are case-sensitive. Valid filter names are: accelerator-types: can provide a list of accelerator type names to filter for. instance-id: can provide a list of EC2 instance ids to filter for. . Defaults to None.
        max_results(int, optional):  The total number of items to return in the command's output. If the total number of items available is more than the value specified, a NextToken is provided in the command's output. To resume pagination, provide the NextToken value in the starting-token argument of a subsequent command. Do not use the NextToken response element directly outside of the AWS CLI. . Defaults to None.
        next_token(str, optional):  A token to specify where to start paginating. This is the NextToken from a previously truncated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.elastic_inference.accelerator.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.elastic_inference.accelerator.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="elastic-inference",
        operation="describe_accelerators",
        op_kwargs={
            "acceleratorIds": accelerator_ids,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
