"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    name: str,
    update_id: str,
    nodegroup_name: str = None,
    addon_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group. When the status of the update is Succeeded, the update is complete. If an update fails, the status is Failed, and an error detail explains the reason for the failure.

    Args:
        name(str): The name of the Amazon EKS cluster associated with the update.
        update_id(str): The ID of the update to describe.
        nodegroup_name(str, optional): The name of the Amazon EKS node group associated with the update. Defaults to None.
        addon_name(str, optional): The name of the add-on. The name must match one of the names returned by  ListAddons . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.update.describe(ctx, name=value, update_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.update.describe name=value, update_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_update",
        op_kwargs={
            "name": name,
            "updateId": update_id,
            "nodegroupName": nodegroup_name,
            "addonName": addon_name,
        },
    )


async def list_all(
    hub,
    ctx,
    name: str,
    nodegroup_name: str = None,
    addon_name: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the updates associated with an Amazon EKS cluster or managed node group in your Amazon Web Services account, in the specified Region.

    Args:
        name(str): The name of the Amazon EKS cluster to list updates for.
        nodegroup_name(str, optional): The name of the Amazon EKS managed node group to list updates for. Defaults to None.
        addon_name(str, optional): The names of the installed add-ons that have available updates. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListUpdates request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.
        max_results(int, optional): The maximum number of update results returned by ListUpdates in paginated output. When you use this parameter, ListUpdates returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListUpdates request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListUpdates returns up to 100 results and a nextToken value if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.update.list_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.update.list_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_updates",
        op_kwargs={
            "name": name,
            "nodegroupName": nodegroup_name,
            "addonName": addon_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
