"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    cluster_name: str,
    nodegroup_name: str,
    version: str = None,
    release_version: str = None,
    launch_template: Dict = None,
    force: bool = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Kubernetes version or AMI version of an Amazon EKS managed node group. You can update a node group using a launch template only if the node group was originally deployed with a launch template. If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template. If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For more information, see Amazon EKS optimized Amazon Linux 2 AMI versions in the Amazon EKS User Guide. You cannot roll back a node group to an earlier Kubernetes version or AMI version. When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can force the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget issue.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster that is associated with the managed node group to update.
        nodegroup_name(str): The name of the managed node group to update.
        version(str, optional): The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify launchTemplate, and your launch template uses a custom AMI, then don't specify version, or the node group update will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        release_version(str, optional): The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see Amazon EKS optimized Amazon Linux 2 AMI versions  in the Amazon EKS User Guide. If you specify launchTemplate, and your launch template uses a custom AMI, then don't specify releaseVersion, or the node group update will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        launch_template(Dict, optional): An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template. Defaults to None.
        force(bool, optional): Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.version.update(
                ctx, cluster_name=value, nodegroup_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.version.update cluster_name=value, nodegroup_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="update_nodegroup_version",
        op_kwargs={
            "clusterName": cluster_name,
            "nodegroupName": nodegroup_name,
            "version": version,
            "releaseVersion": release_version,
            "launchTemplate": launch_template,
            "force": force,
            "clientRequestToken": client_request_token,
        },
    )
