"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cluster_name: str,
    nodegroup_name: str,
    subnets: List,
    node_role: str,
    scaling_config: Dict = None,
    disk_size: int = None,
    instance_types: List = None,
    ami_type: str = None,
    remote_access: Dict = None,
    labels: Dict = None,
    taints: List = None,
    tags: Dict = None,
    client_request_token: str = None,
    launch_template: Dict = None,
    update_config: Dict = None,
    capacity_type: str = None,
    version: str = None,
    release_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see Launch template support. An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux 2 AMI. For more information, see Managed Node Groups in the Amazon EKS User Guide.

    Args:
        cluster_name(str): The name of the cluster to create the node group in.
        nodegroup_name(str): The unique name to give your node group.
        scaling_config(Dict, optional): The scaling configuration details for the Auto Scaling group that is created for your node group. Defaults to None.
        disk_size(int, optional): The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify launchTemplate, then don't specify diskSize, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        subnets(List): The subnets to use for the Auto Scaling group that is created for your node group. If you specify launchTemplate, then don't specify  SubnetId  in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide.
        instance_types(List, optional): Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify AL2_x86_64_GPU with the amiType parameter. If you specify launchTemplate, then you can specify zero or one instance type in your launch template or you can specify 0-20 instance types for instanceTypes. If however, you specify an instance type in your launch template and specify any instanceTypes, the node group deployment will fail. If you don't specify an instance type in a launch template or for instanceTypes, then t3.medium is used, by default. If you specify Spot for capacityType, then we recommend specifying multiple values for instanceTypes. For more information, see Managed node group capacity types and Launch template support in the Amazon EKS User Guide. Defaults to None.
        ami_type(str, optional): The AMI type for your node group. GPU instance types should use the AL2_x86_64_GPU AMI type. Non-GPU instances should use the AL2_x86_64 AMI type. Arm instances should use the AL2_ARM_64 AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify launchTemplate, and your launch template uses a custom AMI, then don't specify amiType, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        remote_access(Dict, optional): The remote access (SSH) configuration to use with your node group. If you specify launchTemplate, then don't specify remoteAccess, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        node_role(str): The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node kubelet daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see Amazon EKS node IAM role in the  Amazon EKS User Guide . If you specify launchTemplate, then don't specify  IamInstanceProfile  in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide.
        labels(Dict, optional): The Kubernetes labels to be applied to the nodes in the node group when they are created. Defaults to None.
        taints(List, optional): The Kubernetes taints to be applied to the nodes in the node group. Defaults to None.
        tags(Dict, optional): The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        launch_template(Dict, optional): An object representing a node group's launch template specification. If specified, then do not specify instanceTypes, diskSize, or remoteAccess and make sure that the launch template meets the requirements in launchTemplateSpecification. Defaults to None.
        update_config(Dict, optional): The node group update configuration. Defaults to None.
        capacity_type(str, optional): The capacity type for your node group. Defaults to None.
        version(str, optional): The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify launchTemplate, and your launch template uses a custom AMI, then don't specify version, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.
        release_version(str, optional): The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see Amazon EKS optimized Amazon Linux 2 AMI versions in the Amazon EKS User Guide. If you specify launchTemplate, and your launch template uses a custom AMI, then don't specify releaseVersion, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see Launch template support in the Amazon EKS User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.init.create(
                ctx, cluster_name=value, nodegroup_name=value, subnets=value, node_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.init.create cluster_name=value, nodegroup_name=value, subnets=value, node_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="create_nodegroup",
        op_kwargs={
            "clusterName": cluster_name,
            "nodegroupName": nodegroup_name,
            "scalingConfig": scaling_config,
            "diskSize": disk_size,
            "subnets": subnets,
            "instanceTypes": instance_types,
            "amiType": ami_type,
            "remoteAccess": remote_access,
            "nodeRole": node_role,
            "labels": labels,
            "taints": taints,
            "tags": tags,
            "clientRequestToken": client_request_token,
            "launchTemplate": launch_template,
            "updateConfig": update_config,
            "capacityType": capacity_type,
            "version": version,
            "releaseVersion": release_version,
        },
    )


async def delete(hub, ctx, cluster_name: str, nodegroup_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon EKS node group for a cluster.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster that is associated with your node group.
        nodegroup_name(str): The name of the node group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.init.delete(
                ctx, cluster_name=value, nodegroup_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.init.delete cluster_name=value, nodegroup_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="delete_nodegroup",
        op_kwargs={"clusterName": cluster_name, "nodegroupName": nodegroup_name},
    )


async def describe(hub, ctx, cluster_name: str, nodegroup_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptive information about an Amazon EKS node group.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster associated with the node group.
        nodegroup_name(str): The name of the node group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.init.describe(
                ctx, cluster_name=value, nodegroup_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.init.describe cluster_name=value, nodegroup_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_nodegroup",
        op_kwargs={"clusterName": cluster_name, "nodegroupName": nodegroup_name},
    )


async def list_all(
    hub, ctx, cluster_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Region. Self-managed node groups are not listed.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster that you would like to list node groups in.
        max_results(int, optional): The maximum number of node group results returned by ListNodegroups in paginated output. When you use this parameter, ListNodegroups returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListNodegroups request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListNodegroups returns up to 100 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListNodegroups request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.init.list_all(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.init.list_all cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_nodegroups",
        op_kwargs={
            "clusterName": cluster_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
