"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    cluster_name: str,
    nodegroup_name: str,
    labels: Dict = None,
    taints: Dict = None,
    scaling_config: Dict = None,
    update_config: Dict = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the DescribeUpdate API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster that the managed node group resides in.
        nodegroup_name(str): The name of the managed node group to update.
        labels(Dict, optional): The Kubernetes labels to be applied to the nodes in the node group after the update. Defaults to None.
        taints(Dict, optional): The Kubernetes taints to be applied to the nodes in the node group after the update. Defaults to None.
        scaling_config(Dict, optional): The scaling configuration details for the Auto Scaling group after the update. Defaults to None.
        update_config(Dict, optional): The node group update configuration. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.nodegroup.config.update(
                ctx, cluster_name=value, nodegroup_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.nodegroup.config.update cluster_name=value, nodegroup_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="update_nodegroup_config",
        op_kwargs={
            "clusterName": cluster_name,
            "nodegroupName": nodegroup_name,
            "labels": labels,
            "taints": taints,
            "scalingConfig": scaling_config,
            "updateConfig": update_config,
            "clientRequestToken": client_request_token,
        },
    )
