"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    cluster_name: str,
    oidc: Dict,
    tags: Dict = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associate an identity provider configuration to a cluster. If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes roles and clusterroles to assign permissions to the roles, and then bind the roles to the identities using Kubernetes rolebindings and clusterrolebindings. For more information see Using RBAC Authorization in the Kubernetes documentation.

    Args:
        cluster_name(str): The name of the cluster to associate the configuration to.
        oidc(Dict): An object that represents an OpenID Connect (OIDC) identity provider configuration.
        tags(Dict, optional): The metadata to apply to the configuration to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.identity_provider_config.associate(
                ctx, cluster_name=value, oidc=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.identity_provider_config.associate cluster_name=value, oidc=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="associate_identity_provider_config",
        op_kwargs={
            "clusterName": cluster_name,
            "oidc": oidc,
            "tags": tags,
            "clientRequestToken": client_request_token,
        },
    )


async def describe(hub, ctx, cluster_name: str, identity_provider_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptive information about an identity provider configuration.

    Args:
        cluster_name(str): The cluster name that the identity provider configuration is associated to.
        identity_provider_config(Dict): An object that represents an identity provider configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.identity_provider_config.describe(
                ctx, cluster_name=value, identity_provider_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.identity_provider_config.describe cluster_name=value, identity_provider_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_identity_provider_config",
        op_kwargs={
            "clusterName": cluster_name,
            "identityProviderConfig": identity_provider_config,
        },
    )


async def disassociate(
    hub,
    ctx,
    cluster_name: str,
    identity_provider_config: Dict,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.

    Args:
        cluster_name(str): The name of the cluster to disassociate an identity provider from.
        identity_provider_config(Dict): An object that represents an identity provider configuration.
        client_request_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.identity_provider_config.disassociate(
                ctx, cluster_name=value, identity_provider_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.identity_provider_config.disassociate cluster_name=value, identity_provider_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="disassociate_identity_provider_config",
        op_kwargs={
            "clusterName": cluster_name,
            "identityProviderConfig": identity_provider_config,
            "clientRequestToken": client_request_token,
        },
    )


async def list_all(
    hub, ctx, cluster_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    A list of identity provider configurations.

    Args:
        cluster_name(str): The cluster name that you want to list identity provider configurations for.
        max_results(int, optional): The maximum number of identity provider configurations returned by ListIdentityProviderConfigs in paginated output. When you use this parameter, ListIdentityProviderConfigs returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListIdentityProviderConfigs request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListIdentityProviderConfigs returns up to 100 results and a nextToken value, if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated IdentityProviderConfigsRequest where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.identity_provider_config.list_all(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.identity_provider_config.list_all cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_identity_provider_configs",
        op_kwargs={
            "clusterName": cluster_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
