"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    fargate_profile_name: str,
    cluster_name: str,
    pod_execution_role_arn: str,
    subnets: List = None,
    selectors: List = None,
    client_request_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate. The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate. When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes Role Based Access Control (RBAC) for authorization so that the kubelet that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see Pod Execution Role in the Amazon EKS User Guide. Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating. If any Fargate profiles in a cluster are in the DELETING status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster. For more information, see Fargate Profile in the Amazon EKS User Guide.

    Args:
        fargate_profile_name(str): The name of the Fargate profile.
        cluster_name(str): The name of the Amazon EKS cluster to apply the Fargate profile to.
        pod_execution_role_arn(str): The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see Pod Execution Role in the Amazon EKS User Guide.
        subnets(List, optional): The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter. Defaults to None.
        selectors(List, optional): The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        tags(Dict, optional): The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.fargate_profile.create(
                ctx, fargate_profile_name=value, cluster_name=value, pod_execution_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.fargate_profile.create fargate_profile_name=value, cluster_name=value, pod_execution_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="create_fargate_profile",
        op_kwargs={
            "fargateProfileName": fargate_profile_name,
            "clusterName": cluster_name,
            "podExecutionRoleArn": pod_execution_role_arn,
            "subnets": subnets,
            "selectors": selectors,
            "clientRequestToken": client_request_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, cluster_name: str, fargate_profile_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Fargate profile. When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state. Only one Fargate profile in a cluster can be in the DELETING status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster associated with the Fargate profile to delete.
        fargate_profile_name(str): The name of the Fargate profile to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.fargate_profile.delete(
                ctx, cluster_name=value, fargate_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.fargate_profile.delete cluster_name=value, fargate_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="delete_fargate_profile",
        op_kwargs={
            "clusterName": cluster_name,
            "fargateProfileName": fargate_profile_name,
        },
    )


async def describe(hub, ctx, cluster_name: str, fargate_profile_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptive information about an Fargate profile.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster associated with the Fargate profile.
        fargate_profile_name(str): The name of the Fargate profile to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.fargate_profile.describe(
                ctx, cluster_name=value, fargate_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.fargate_profile.describe cluster_name=value, fargate_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_fargate_profile",
        op_kwargs={
            "clusterName": cluster_name,
            "fargateProfileName": fargate_profile_name,
        },
    )


async def list_all(
    hub, ctx, cluster_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Region.

    Args:
        cluster_name(str): The name of the Amazon EKS cluster that you would like to list Fargate profiles in.
        max_results(int, optional): The maximum number of Fargate profile results returned by ListFargateProfiles in paginated output. When you use this parameter, ListFargateProfiles returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListFargateProfiles request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListFargateProfiles returns up to 100 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListFargateProfiles request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.fargate_profile.list_all(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.fargate_profile.list_all cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_fargate_profiles",
        op_kwargs={
            "clusterName": cluster_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
