"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    cluster_name: str,
    encryption_config: List,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associate encryption configuration to an existing cluster. You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.

    Args:
        cluster_name(str): The name of the cluster that you are associating with encryption configuration.
        encryption_config(List): The configuration you are using for encryption.
        client_request_token(str, optional): The client request token you are using with the encryption configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.encryption_config.associate(
                ctx, cluster_name=value, encryption_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.encryption_config.associate cluster_name=value, encryption_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="associate_encryption_config",
        op_kwargs={
            "clusterName": cluster_name,
            "encryptionConfig": encryption_config,
            "clientRequestToken": client_request_token,
        },
    )
